/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class Utils {
    private static final String TRACE_MASKT = "HUIUTILT";
    private static final String TRACE_MASKF = "HUIUTILF";
    private static final String TRACE_MASKD = "HUIUTILD";

    public static ObjectId getTaskObjectIdFromPortal(PanelModelTaskPortal portal) {
        Trace.trace(TRACE_MASKT, "-> Utils.getTaskObjectIdFromPortal()");
        ObjectId result = null;
        PresentationTaskParms parms = Utils.getPresentationTaskParms(portal);
        if (parms != null) {
            result = parms.getTaskId();
            if (result == null) {
                Trace.trace(TRACE_MASKF, "   There is no task ObjectId in PresentationTaskParms");
            } else {
                Trace.trace(TRACE_MASKF, "   returning ObjectId " + result);
            }
        }
        Trace.trace(TRACE_MASKT, "<- Utils.getTaskObjectIdFromPortal()");
        return result;
    }

    public static String getTaskShortIdFromPortal(PanelModelTaskPortal portal) {
        Trace.trace(TRACE_MASKT, "-> Utils.getTaskShortIdFromPortal()");
        String result = null;
        PresentationTaskParms parms = Utils.getPresentationTaskParms(portal);
        if (parms != null) {
            result = parms.getUIShortId();
            if (result == null) {
                Trace.trace(TRACE_MASKF, "   There is no task short identifier in PresentationTaskParms");
            } else {
                Trace.trace(TRACE_MASKF, "   returning short identifier " + result);
            }
        }
        Trace.trace(TRACE_MASKT, "<- Utils.getTaskShortIdFromPortal()");
        return result;
    }

    public static Collection getRunningTaskShortIds(HMCSession hmcSession) {
        Trace.trace(TRACE_MASKT, "-> Utils.getRunningTaskShortIds()");
        HashSet<String> result = new HashSet<String>();
        Collection tasks = hmcSession.getRunningTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            String shortId = Utils.getTaskShortIdFromPortal((PanelModelTaskPortal)iterator.next());
            if (shortId == null) continue;
            result.add(shortId);
        }
        Trace.trace(TRACE_MASKT, "<- Utils.getRunningTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public static boolean checkForActiveTask(String taskShortId, HMCSession hmcSession) {
        Iterator iterator = hmcSession.getRunningTasks().iterator();
        boolean active = false;
        while (iterator.hasNext() && !active) {
            String nextTaskShortId = Utils.getTaskShortIdFromPortal((PanelModelTaskPortal)iterator.next());
            if (nextTaskShortId == null || !nextTaskShortId.equals(taskShortId)) continue;
            active = true;
        }
        return active;
    }

    private static PresentationTaskParms getPresentationTaskParms(PanelModelTaskPortal portal) {
        PresentationTaskParms result = null;
        PresentationTask pt = portal.getPresentationTask();
        if (pt == null) {
            Trace.trace(TRACE_MASKF, "   There is no PresentationTask in PanelModelPortalTask");
        } else {
            result = pt.getParms();
            if (result == null) {
                Trace.trace(TRACE_MASKF, "   There is no PresentationTaskParms in PresentationTask");
            }
        }
        return result;
    }
}

